angular.module('templates').run(['$templateCache', function($templateCache) {$templateCache.put('../teacher/dialog/assessment-add-questions.html','<div class="erudex-dialog fixed-dialog-buttons">\n    <div class="dialog-header">\n      <img src="../img/icons/company-logo.png" alt="logo" class="logo">\n    </div>\n    <div class="dialog-content">\n  \n      <div class="row">\n        <div class="columns small-1">\n          <label class="inline-label text-center">Grade</label>\n  \n          <label ng-hide="(assessmentType === ASSESSMENT_TYPE.COMPETITIVE_MOCK_TEST) || (assessmentType === ASSESSMENT_TYPE.COMPETITIVE_PRACTICE)" class="inline-label text-center">\n            {{ grade.number || grade.description }}\n          </label>\n  \n          <select ng-model="grade" ng-change="onChangeGrade(grade)" ng-options="opt.value as opt.name for opt in gradeOptions" ng-show="(assessmentType === ASSESSMENT_TYPE.COMPETITIVE_MOCK_TEST) || (assessmentType === ASSESSMENT_TYPE.COMPETITIVE_PRACTICE)">\n          </select>\n  \n        </div>\n  \n        <div class="columns small-2">\n          <label class="inline-label text-center">Subject</label>\n  \n          <label ng-hide="(assessmentType === ASSESSMENT_TYPE.COMPETITIVE_MOCK_TEST) || (assessmentType === ASSESSMENT_TYPE.COMPETITIVE_PRACTICE)" class="inline-label text-center">\n            {{language.id === languageConstants.ENGLISH ? subject.name : (subject.altName || subject.name)}}\n          </label>\n  \n          <select ng-model="subject" ng-change="onChangeSubject(subject)" ng-options="opt.value as opt.name for opt in subjectOptions" ng-show="(assessmentType === ASSESSMENT_TYPE.COMPETITIVE_MOCK_TEST) || (assessmentType === ASSESSMENT_TYPE.COMPETITIVE_PRACTICE)">\n            <option selected="selected" value="">All Subjects</option>\n          </select>\n        </div>\n  \n        <div class="columns small-2">\n          <label class="inline-label text-center">Question Type</label>\n          <select ng-model="filter.questionType" ng-change="onChangeQuestionType(filter.questionType)" ng-options="obj.value as obj.name for obj in questionTypeOptions">\n            <option selected="selected" value="">All Question Types</option>\n          </select>\n        </div>\n        \n        <div class="columns small-2">\n          <label class="inline-label text-center">Created By</label>\n          <select ng-model="filter.createdUserId" ng-change="applyFilter(filter)">\n            <option selected="filter.createdUserId == null || filter.createdUserId == \'\' " value="">All</option>\n            <option type="number" selected="filter.createdUserId == user.id" value="{{user.id}}">Me</option>\n          </select>\n        </div>\n\n        <div class="columns small-2 end" ng-hide="features.questionAdd.offlineSearch">\n          <label class="inline-label text-center">Description</label>\n          <input type="text" maxlength="100" ng-model="filter.description">\n        </div>\n      </div>\n  \n  \n      <div class="row text-center no-select">\n        <div class="e-button radius" ng-click="clearFilter()">Clear Filter</div>\n        <div class="e-button radius" ng-click="applyFilter()">Apply Filter</div>\n      </div>\n  \n      <table class="f-table striped">\n        <thead>\n        <tr ng-show="selectedSubjects.length > 0">\n          <th class="text-right">\n            &nbsp;\n          </th>\n          <th>\n            <div class="row text-right">\n              <div ng-repeat="subject in selectedSubjects" class="columns small-3 end">\n                {{subject.name}} - {{subject.count}}\n              </div>\n            </div>\n          </th>\n          <th colspan="3" class="text-right">\n            &nbsp;\n          </th>\n        </tr>\n        <tr>\n          <th width="6%"> No.</th>\n          <th width="62%"> Question</th>\n          <th width="13%"> Question Type</th>\n          <th width="13%"> Created By</th>\n          <th width="6%"> Action</th>\n        </tr>\n        </thead>\n        <tbody>\n        <tr ng-if="!loadedQuestions || loadedQuestions.length === 0">\n          <td colspan="5"><em>No Questions Available</em></td>\n        </tr>\n        <tr ng-repeat="rec in loadedQuestions track by $index">\n          <td ng-click="viewQuestion(rec)">{{(search.pagination.pageIndex*search.pagination.pageSize)+$index+1}}</td>\n          <td class="ques-text" ng-click="viewQuestion(rec)">\n            <mathjax-mcq-bind mcq="rec"></mathjax-mcq-bind>\n          </td>\n          <td class="text-left">\n            <label class="inline-elem">{{(rec.questionType|capitalizeConstant)||\'N/A\'}}</label><br>\n          </td>\n          <td class="text-left">\n            <label class="inline-elem">{{(rec.createdUsername)||\'N/A\'}}</label><br>\n            <label class="inline-elem">{{rec.createdDateTime | date:\'dd-MM-yyyy hh:mm a\'}}</label>\n          </td>\n          <td class="no-select">\n            <div class="e-button radius" ng-click="selectQuestion(rec)" ng-show="rec.isActive">\n              {{isSelectedQuestion(rec.id)?\'Deselect\':\'Add\'}}\n            </div>\n            <div ng-hide="rec.isActive"><em>Disabled</em></div>\n            <div class="e-button radius" ng-click="viewQuestionHistory(rec.id)">Info</div>\n          </td>\n        </tr>\n        </tbody>\n      </table>\n  \n    </div>\n    <div class="dialog-buttons">\n      <div class="pagination-footer row">\n        <div class="columns small-5">\n          <div class="row">\n            <div class="columns small-6 text-left">\n              Search Results: {{(search.pagination.pageIndex*search.pagination.pageSize)+1}}\n              - {{(search.pagination.pageIndex*search.pagination.pageSize)+loadedQuestions.length}}/{{totalQuestions}}\n            </div>\n            <div class="columns small-6">\n              Page: {{search.pagination.pageIndex+1}}/{{totalPages}}\n            </div>\n          </div>\n        </div>\n        <div class="columns small-2">\n          <div class="e-button radius" ng-click="cancel()">Cancel</div>\n          <div class="e-button radius" ng-click="okay()">Ok</div>\n        </div>\n        <div class="columns small-5">\n          <div class="row">\n            <div class="columns small-8 text-right">\n              <pagination boundary-links="true" total-items="totalQuestions" page="search.pagination.pageIndex+1" on-select-page="goToPage(page)" max-size="5" rotate="true" class="pagination-fixed" previous-text="&lt;" next-text="&gt;" first-text="&lt;&lt;" last-text="&gt;&gt;"></pagination>\n            </div>\n            <div class="columns small-2 text-right">\n              <div class="go-to-label">Go To:</div>\n            </div>\n            <div class="columns small-2">\n              <span class="go-to-select">\n              <input type="number" class="text-center" ng-model="search.pagination.jumpToPageNum" ng-keydown="$event.keyCode===13 ? goToPage(search.pagination.jumpToPageNum) || $event.preventDefault():\'\'">\n              </span>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n');
$templateCache.put('../teacher/dialog/add-ext-link.html','<div class="erudex-dialog">\n  <div class="dialog-header">\n    <img src="../img/icons/company-logo.png" alt="logo" class="logo">\n  </div>\n  <div class="dialog-content">\n    <div class="row collapse">\n      <label>Name</label>\n\n      <div class="columns small-12">\n        <input type="text" ng-model="linkName" class="form-control">\n      </div>\n    </div>\n    <div class="clearfix"></div>\n    <label>URL</label>\n\n    <div class="clearfix"></div>\n    <div class="row collapse">\n      <div class="small-3 large-2 columns">\n        <span class="prefix">http://</span>\n      </div>\n      <div class="small-9 large-10 columns">\n        <input type="text" ng-model="externalLink" placeholder="Enter your URL...">\n      </div>\n    </div>\n    <div class="row">\n      <div class="columns small-12 mid-bt">\n        <a ng-click="closeThisDialog()" class="e-button radius">Cancel</a>\n        <a ng-click="addLink()" class="e-button radius">Add Link</a>\n      </div>\n    </div>\n  </div>\n</div>\n');
$templateCache.put('../teacher/dialog/question-view-history.html','<div class="erudex-dialog">\n    <div class="dialog-header">\n      <img src="../img/icons/company-logo.png" alt="logo" class="logo-left">\n      Question History\n    </div>\n    <div class="dialog-content">\n      <div class="ques-history-modal">\n        <table class="f-table striped">\n          <thead>\n          <tr>\n            <th> Assessment Name</th>\n            <th> Assessment Type</th>\n            <th> Created By</th>\n            <th> Created Date</th>\n          </tr>\n          </thead>\n          <tbody>\n          <tr ng-repeat="rec in mcqHistory">\n            <td>{{rec[1]}}</td>\n            <td>{{getAssessmentType(rec[3]||rec[3])}}</td>\n            <td>{{rec[0]}}</td>\n            <td>{{rec[4] | date:\'dd-MM-yyyy\'}}</td>\n          </tr>\n          <tr ng-show="isHistoryLoaded && (mcqHistory.length === 0)">\n            <td colspan="5">This question not used in any assessment yet.</td>\n          </tr>\n          </tbody>\n        </table>\n      </div>\n    </div>\n    <div class="form-horizontal" role="form" id="panActions">\n      <div class="form-group">\n        <div class="row">\n          <div class="columns medium-12 small-12 mid-bt">\n            <a class="e-button radius" ng-click="closeThisDialog()">Close</a>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n  ');
$templateCache.put('../teacher/dialog/add-grade-book-item.html','<div class="erudex-dialog">\n  <div class="dialog-header">\n    <img src="../img/icons/company-logo.png" alt="logo" class="logo">\n  </div>\n  <div class="dialog-content">\n\n    <div class="form-group required" style="padding:0 2rem">\n      <div class="row">\n        <div class="column small-5 control-label text-right">Class</div>\n        <div class="column small-7">{{grade.description}}&nbsp;{{grade.number}}</div>\n      </div>\n      <div class="row">\n        <div class="column small-5 control-label text-right">Subject</div>\n        <div class="column small-7">{{subject.name}}</div>\n      </div>\n      <div class="row">\n        <div class="column small-5 control-label text-right">Section</div>\n        <div class="column small-7">{{section.name}}</div>\n      </div>\n      <div class="row">\n        <div class="column small-5 control-label text-right inline-label">Chapter</div>\n        <div class="column small-7">\n          <select ng-model="chapterId" ng-options="chapter.id as (chapter.number + \'. \' + chapter.name) for chapter in chapterOptions | orderBy:\'sortOrder\'">\n            <option value="">Select Chapter</option>\n          </select>\n        </div>\n      </div>\n      <div class="row">\n        <div class="column small-5 control-label text-right inline-label">{{type|capitalize}} Name</div>\n        <div class="column small-7"><input type="text" ng-model="name"></div>\n      </div>\n      <div class="row" style="margin-bottom:1rem">\n        <div class="column small-5 control-label text-right inline-label">Start Date</div>\n        <div class="column small-7">\n          <date-picker-e options="{autoclose:true}" data-date-format="dd-mm-yyyy" date-ms-model="startDate" date-end="endDate"></date-picker-e>\n        </div>\n      </div>\n      <div class="row" style="margin-bottom:1rem">\n        <div class="column small-5 control-label text-right inline-label">End Date</div>\n        <div class="column small-7">\n          <date-picker-e options="{autoclose:true}" data-date-format="dd-mm-yyyy" date-ms-model="endDate" date-start="startDate"></date-picker-e>\n        </div>\n      </div>\n      <div class="row">\n        <div class="column small-5 control-label text-right inline-label">Marks</div>\n        <div class="column small-7">\n          <select ng-model="totalMarks" ng-options="mark for mark in markOptions"></select>\n        </div>\n      </div>\n\n    </div>\n\n    <div class="row text-center">\n      <div class="e-button radius" ng-click="closeThisDialog()">Cancel</div>\n      <div class="e-button radius" ng-click="createAndPush()">Create & Push</div>\n    </div>\n\n\n  </div>\n</div>\n\n\n');
$templateCache.put('../teacher/dialog/add-lesson-plan-resources.html','<div class="erudex-dialog">\n  <div class="dialog-header">\n    <img src="../img/icons/company-logo.png" alt="logo" class="logo-left">\n    {{plan.name}}&nbsp;Attachments\n  </div>\n  <div class="dialog-content">\n    <div class="row">\n      <div class="columns small-12 medium-6 text-center">\n        <div class="select-resource-list-title">Content Resources\n          <i class="fa fa-plus select-resource-add" ng-click="addMultiMediaLink()"> </i>\n        </div>\n\n        <div class="select-resource-list" ui-sortable="editResourceSortableOptions" ng-model="resources">\n          <div ng-repeat="aRes in resources track by $index" class="select-resource-list-item noselect">\n            <img ng-src="{{aRes.iconUri||(\'../img/icons/\' + subject.iconType + \'/\' + aRes.displayType + \'.png\'|trustResUrl)}}" class="resource-icon">\n            <span class="resource-name">\n              {{languageId === languageConstants.ENGLISH ? aRes.name : (aRes.altName || aRes.name)}}\n            </span>\n            <i class="fa fa-trash resource-delete-icon" ng-click="deleteResource($index)"> </i>\n            <i class="fa fa-eye resource-preview-icon" ng-click="previewResource(aRes)"> </i>\n          </div>\n        </div>\n      </div>\n\n      <div class="columns small-12 medium-6 text-center">\n        <div class="select-resource-list-title">External Links <span ng-hide="!isOffline"> (Not available when offline)</span>\n          <i class="fa fa-plus select-resource-add" ng-hide="isOffline" ng-click="addExternalLink()">\n          </i>\n        </div>\n\n        <div class="select-resource-list" ui-sortable="editResourceSortableOptions" ng-model="links">\n          <div ng-repeat="link in links track by $index" class="select-resource-list-item noselect">\n            <i class="fa fa-external-link external-link-icon"> </i>\n            <span class="resource-name">{{link.name}}</span>\n            <i class="fa fa-trash resource-delete-icon" ng-click="deleteLink($index)"> </i>\n            <i class="fa fa-eye resource-preview-icon" ng-click="previewLink(link)"> </i>\n          </div>\n        </div>\n      </div>\n\n    </div>\n\n    <div class="row">\n      <div class="delete-resource-zone small-12 medium-8 medium-offset-2 end text-center ng-hide" ng-show="isDragging" ui-sortable="deleteZone" ng-model="deleteZoneFields">\n        <div ng-repeat="item in deleteZoneFields track by $index"></div>\n      </div>\n    </div>\n\n    <div class="row spacer-margin-top">\n      <div class="columns small-12 mid-bt">\n        <a ng-click="cancelDialog()" class="e-button radius">Cancel</a>\n        <a ng-click="saveAndFinish()" class="e-button radius">Save</a>\n      </div>\n    </div>\n  </div>\n\n</div>\n');
$templateCache.put('../teacher/dialog/assessment-search.html','<div class="erudex-dialog fixed-dialog-buttons">\n  <div class="dialog-header">\n    <img src="../img/icons/company-logo.png" alt="logo" class="logo">\n  </div>\n  <div class="dialog-content">\n\n    <div class="row">\n      <div class="columns small-1 small-offset-1">\n        <label class="inline-label text-right">Name</label>\n      </div>\n      <div class="columns medium-2 small-2">\n        <input type="text" ng-model="filter.name" class="form-control" placeholder="Assessment Name" ng-trim="true">\n      </div>\n\n      <div class="columns small-1">\n        <label class="inline-label text-right">Level</label>\n      </div>\n      <div class="columns medium-2 small-2 end">\n        <select class="form-control" ng-model="filter.difficultyLevel" ng-options="opt.value as opt.name for opt in difficultyLevelOptions">\n          <option value="" selected="selected">All Difficulties</option>\n        </select>\n      </div>\n\n      <div class="columns small-1">\n        <label class="inline-label text-right">Owner</label>\n      </div>\n      <div class="columns medium-2 small-2 end">\n        <select class="form-control" ng-model="filter.owner" ng-options="opt.value as opt.name for opt in ownerOptions">\n          <option value="" selected="selected">All Owners</option>\n        </select>\n      </div>\n    </div>\n\n    <div class="row">\n      <div class="columns small-1 small-offset-1">\n        <label class="inline-label text-right">Date</label>\n      </div>\n      <div class="columns medium-2 small-2 end">\n        <select ng-model="dateFilter.type" ng-change="onChangeDateType(dateFilter.type)" ng-options="dType.value as dType.name for dType in dateTypeOptions">\n          <option value="" selected="selected">All Dates</option>\n        </select>\n      </div>\n\n      <div class="columns small-1">\n        <label class="inline-label text-right">From</label>\n      </div>\n      <div class="columns medium-2 small-2 end">\n        <date-picker-e data-date-format="dd-mm-yyyy" options="{autoclose:true}" date-ms-model="dateFilter.low" date-end="dateFilter.high" ng-disabled="!dateFilter.type">\n        </date-picker-e>\n      </div>\n\n      <div class="columns small-1">\n        <label class="inline-label text-right">To</label>\n      </div>\n      <div class="columns medium-2 small-2 end">\n        <date-picker-e data-date-format="dd-mm-yyyy" options="{autoclose:true}" date-ms-model="dateFilter.high" date-start="dateFilter.low" ng-disabled="!dateFilter.type">\n        </date-picker-e>\n      </div>\n\n    </div>\n\n    <div class="row text-center no-select">\n      <div class="e-button radius" ng-click="clearFilter()">Clear Filter</div>\n      <div class="e-button radius" ng-click="applyFilter()">Apply Filter</div>\n    </div>\n\n    <table class="f-table striped" ts-wrapper>\n      <thead>\n      <tr>\n        <th width="6%">\n          No.\n        </th>\n        <th>\n          Name\n        </th>\n        <th>\n          Grade\n        </th>\n        <th>\n          Subject\n        </th>\n        <th>\n          Chapter\n        </th>\n\n        <th>\n          Type\n        </th>\n\n        <th>\n          Created Date\n        </th>\n        <th>\n          Last Modified Date\n        </th>\n\n        <th width="6%">\n          Action\n        </th>\n      </tr>\n      </thead>\n      <tbody>\n      <tr ng-repeat="rec in assessments track by $index" style="cursor:pointer" ng-click="viewAssessment(rec)">\n        <td>\n          {{(search.pagination.pageIndex*search.pagination.pageSize)+$index+1}}\n        </td>\n        <td>{{rec.append.name}}</td>\n        <td>{{rec.append.grade.number}}</td>\n        <td>{{rec.append.subject.name}}</td>\n        <td>\n          <ul style="text-align:left">\n            <li ng-repeat="chapter in rec.append.chapters | orderBy: \'sortOrder\'">{{chapter.name}}</li>\n          </ul>\n        </td>\n        <td>{{rec.append.assessmentType}}</td>\n        <td>{{rec.append.createdDateTime | date:\'dd-MM-yyyy\'}}</td>\n        <td>{{rec.append.updatedDateTime | date:\'dd-MM-yyyy\'}}</td>\n        <td>\n          <div class="e-button radius" ng-click="selectAssessment(rec)">Select</div>\n        </td>\n\n      </tr>\n\n      <tr ng-show="!assessments.length">\n        <td colspan="9" align="center">No Assessments available</td>\n      </tr>\n\n      </tbody>\n\n      <tfoot>\n      <tr>\n        <td class="no-select">\n          <div class="e-button radius" ng-disabled="disabled.prevBtn" ng-click="goToPage(search.pagination.pageIndex-1)">Prev\n          </div>\n        </td>\n        <td colspan="7">\n          {{(search.pagination.pageIndex*search.pagination.pageSize)+1}}\n          - {{(search.pagination.pageIndex*search.pagination.pageSize)+assessments.length}}/{{totalItems}}\n        </td>\n        <td class="no-select">\n          <div class="e-button radius" ng-disabled="disabled.nextBtn" ng-click="goToPage(search.pagination.pageIndex+1)">Next\n          </div>\n        </td>\n      </tr>\n      </tfoot>\n    </table>\n  </div>\n  <div class="dialog-buttons no-select">\n    <div class="e-button radius" ng-click="cancel()">Cancel</div>\n  </div>\n</div>\n');
$templateCache.put('../teacher/dialog/change-password.html','<div class="erudex-dialog">\n  <div class="dialog-header">\n    <img src="../img/icons/company-logo.png" alt="logo" class="logo">\n  </div>\n\n  <form name="changePasswordForm" class="dialog-content">\n\n    <div class="row text-center no-select">\n      <label class="small-6 small-offset-3">\n        <input type="checkbox" ng-model="changePasswordSelected.isChangingStudentPassword" name="isChangingStudentPassword">\n        Reset student password\n      </label>\n    </div>\n\n    <div role="alert">\n      <span class="error ng-hide" ng-show="errorMsg">\n      {{errorMsg}}\n      </span>\n    </div>\n\n    <div class="row" ng-show="changePasswordSelected.isChangingStudentPassword">\n\n      <label class="columns small-4 inline text-right">\n        Grade\n      </label>\n\n      <div class="columns small-8">\n        <select ng-model="changePasswordSelected.grade" ng-change="onChangeGrade(changePasswordSelected.grade)" ng-options="grade.value as grade.name for grade in gradeOptions">\n          <option selected="selected" disabled="disabled" value="">Select Grade</option>\n        </select>\n      </div>\n    </div>\n\n    <div class="row" ng-show="changePasswordSelected.isChangingStudentPassword">\n\n      <label class="columns small-4 inline text-right">\n        {{sectionLabel}}\n      </label>\n\n      <div class="columns small-8">\n        <select ng-model="changePasswordSelected.section" ng-disabled="!changePasswordSelected.grade" ng-change="onChangeSection(changePasswordSelected.section)" ng-options="section.value as section.name for section in sectionOptions|orderBy: \'name\'">\n          <option selected="selected" disabled="disabled" value="">Select {{sectionLabel}}</option>\n        </select>\n      </div>\n    </div>\n\n    <div class="row" ng-show="changePasswordSelected.isChangingStudentPassword">\n\n      <label class="columns small-4 inline text-right">\n        Student\n      </label>\n\n      <div class="columns small-8">\n        <select ng-model="changePasswordSelected.student" ng-disabled="!changePasswordSelected.section" ng-required="changePasswordSelected.isChangingStudentPassword" name="selectedStudent" ng-options="user.value as user.name for user in studentOptions|orderBy: \'name\'">\n          <option selected="selected" disabled="disabled" value="">Select Student</option>\n        </select>\n      </div>\n    </div>\n\n    <div class="row" ng-hide="changePasswordSelected.isChangingStudentPassword">\n      <label class="columns small-4 inline text-right">\n        Current Password\n      </label>\n\n      <div class="columns small-8">\n        <input ng-required="!changePasswordSelected.isChangingStudentPassword" type="password" ng-model="changePassword.current" name="currentPassword" class="error" minlength="1" maxlength="{{CHANGE_PASS.MAX_LENGTH}}">\n\n        <div ng-messages="changePasswordForm.currentPassword.$error" ng-show="changePasswordForm.currentPassword.$dirty">\n          <small class="error" ng-message="required">\n            Please confirm your current password.\n          </small>\n        </div>\n      </div>\n    </div>\n\n    <div class="row">\n      <label class="columns small-4 inline text-right">\n        New Password\n      </label>\n\n      <div class="columns small-8">\n        <input required type="password" ng-model="changePassword.new" name="newPassword" class="error" minlength="{{CHANGE_PASS.MIN_LENGTH}}" maxlength="{{CHANGE_PASS.MAX_LENGTH}}" onkeydown="return /[A-Z0-9]/.test(event.key)">\n\n        <div ng-messages="changePasswordForm.newPassword.$error" ng-show="changePasswordForm.newPassword.$dirty">\n          <small class="error" ng-message="required">\n            Please enter a new password.\n          </small>\n        </div>\n      </div>\n    </div>\n\n    <div class="row">\n      <label class="columns small-4 inline text-right">\n        Confirm Password\n      </label>\n\n      <div class="columns small-8">\n        <input required type="password" ng-model="changePassword.newVerify" name="newPasswordVerify" class="error" onkeydown="return /[A-Z0-9]/.test(event.key)" minlength="{{CHANGE_PASS.MIN_LENGTH}}" maxlength="{{CHANGE_PASS.MAX_LENGTH}}" confirm-password-check="changePassword.new">\n\n        <div ng-messages="changePasswordForm.newPasswordVerify.$error" ng-show="changePasswordForm.newPasswordVerify.$dirty">\n          <small class="error" ng-message="required">\n            Please confirm new password.\n          </small>\n          <small class="error" ng-message="noMatch">\n            Passwords do not match\n          </small>\n        </div>\n      </div>\n    </div>\n\n    <div class="row text-center">\n      <input type="button" class="e-button radius" ng-click="$dismiss()" value="Cancel">\n      <input type="submit" class="e-button radius" ng-click="changePasswordForm.$valid && submitChangePassword()" value="Save" ng-disabled="!changePasswordForm.$valid">\n    </div>\n    <div style="font-size: .75rem; color: red; padding: .75rem 0">\n      *Note: Passwords must be between {{::CHANGE_PASS.MIN_LENGTH}} and {{::CHANGE_PASS.MAX_LENGTH}} characters, must contain all uppercase letters and/or numbers. No spaces.\n    </div>\n  </form>\n</div>\n');
$templateCache.put('../teacher/dialog/editor.html','<div class="erudex-dialog">\n  <div class="dialog-header">\n    <img src="../img/icons/company-logo.png" alt="logo" class="logo-left">\n    {{editor.name}}\n  </div>\n  <div class="dialog-content">\n    <div class="wys-edit">\n      <wysiwyg textarea-id="detail" textarea-class="form-control" textarea-height="200px" textarea-name="textareadetail" textarea-ng-required="true" ng-model="editor.content" enable-bootstrap-title="true" textarea-menu="editor.menu" textarea-custom-menu="custom">\n      </wysiwyg>\n    </div>\n    <br>\n\n    <div class="text-center">\n      <div class="e-button radius" ng-click="cancelDialog()">Cancel</div>\n      <div class="e-button radius" ng-click="finishDialog()">Ok</div>\n    </div>\n  </div>\n</div>\n');
$templateCache.put('../teacher/dialog/file-download.html','<div class="erudex-dialog">\n  <div class="dialog-header">\n    <img src="../img/icons/company-logo.png" alt="logo" class="logo">\n  </div>\n  <div class="dialog-content">\n\n    <div class="row text-center">\n      <div>Press "Download" below or right-click->"save as.." to download file.</div>\n      <br>\n      <!-- download attribute does not work in IE/Safari -->\n      <a class="e-button radius" href="{{downloadUri}}" download="{{downloadFilename}}">Download</a>\n    </div>\n    <br>\n    <div class="row">\n      <div class="columns small-12 mid-bt">\n        <a ng-click="closeThisDialog()" class="e-button radius">Close</a>\n      </div>\n    </div>\n  </div>\n</div>');
$templateCache.put('../teacher/dialog/grade-comment.html','<div class="erudex-dialog">\n  <div class="dialog-header">\n    <img src="../img/icons/company-logo.png" alt="logo" class="logo">\n  </div>\n  <div class="dialog-content">\n\n    <form class="form-horizontal row">\n      <label class="columns small-12 text-left">{{isFeedback ? \'Feedback\' : \'Comment\'}}</label>\n      <div class="columns small-12">\n          <textarea id="popupGradeComment" ng-model="gradeComment" class="form-control" rows="4" style="width:100%;resize:none"></textarea>\n      </div>\n      <div class="row text-center">\n        <a ng-click="cancelComment()" class="e-button radius">Cancel</a>\n        <a ng-click="saveComment()" class="e-button radius">Save</a>\n      </div>\n    </form>\n\n  </div>\n</div>\n\n\n');
$templateCache.put('../teacher/dialog/push-coursework.html','<div class="erudex-dialog">\n  <div class="dialog-header">\n    <img src="../img/icons/company-logo.png" alt="logo" class="logo">\n  </div>\n\n  <form class="dialog-content">\n    <div class="row">\n      <div class="share-groups" ng-class="{\'width-100p\':hideStudents}">\n        <div class="share-column-title" ng-show="!isMauritiusBuild">Sections</div>\n        <div class="share-column-title" ng-show="isMauritiusBuild">Classes</div>\n        <div class="share-scroll">\n          <div class="share-groups-item" ng-repeat="section in sectionGroups">\n            <label>\n              <input type="checkbox" ng-model="section.checked" ng-change="onSectionChecked(section)" cb-indeterminate="section.indeterminate">\n              {{section.name}}\n            </label>\n            <div class="share-open-group text-center" ng-click="setSection(section)" ng-hide="hideStudents">\n              <i class="fa fa-chevron-right"> </i>\n            </div>\n            <div class="group-list-divider"></div>\n          </div>\n        </div>\n      </div>\n      <div class="share-users" ng-hide="hideStudents">\n        <div class="share-column-title">{{selected.section.name||\'No Selection\'}}</div>\n        <div class="share-scroll">\n          <div class="share-groups-item text-center" ng-show="!selected.section">Select a {{gradeLabel}} to see students.</div>\n          <div class="share-groups-item" ng-repeat="student in selected.section.students">\n            <label title="{{student.userName}}">\n              <input type="checkbox" ng-model="student.checked" ng-change="onStudentChecked(selected.section, student)">\n              {{student.name}}\n            </label>\n            <div class="group-list-divider"></div>\n          </div>\n        </div>\n      </div>\n    </div>\n    <div class="row spacer-margin-top" style="padding:0 1.5rem 0 0" ng-hide="hideDates">\n\n      <label class="columns small-6 text-center">\n        Start Date\n<!-- Old Date only code -->\n        <!-- <date-picker-e options="{autoclose:true,startDate:\'now\'}" data-date-format="dd-mm-yyyy"\n                       date-ms-model="startDate" date-end="endDate"></date-picker-e> -->\n<!-- Date Time Picker Added By Maaz Kabir on 13/01/2020 -->\n                       <input type="datetime-local" id="startDateTimeInput" ng-model="startDate" placeholder="MM-dd-yyyyThh:mm a" min="{{min}}" required ng-change="onStartDateChange()">\n      </label>\n\n      <label class="columns small-6 text-center">\n        End Date\n<!-- Old Date only code -->\n        <!-- <date-picker-e options="{autoclose:true,startDate:\'now\'}" data-date-format="dd-mm-yyyy"\n                       date-ms-model="endDate" date-start="startDate"></date-picker-e> -->\n<!-- Date Time Picker Added By Maaz Kabir on 13/01/2020 -->\n        <input type="datetime-local" id="endDateTimeInput" ng-model="endDate" placeholder="MM-dd-yyyyThh:mm a" min="{{minEndDate}}" required>\n      </label>\n\n    </div>\n    <div class="row text-center spacer-margin-top">\n      <div data-dismiss="modal" class="e-button radius" ng-click="cancelPush()">\n        Cancel\n      </div>\n      <div data-dismiss="modal" class="e-button radius" ng-click="submitPush()">\n        {{actionText}}\n      </div>\n    </div>\n  </form>\n</div>\n\n');
$templateCache.put('../teacher/dialog/question-view-solution.html','<div class="erudex-dialog">\n  <div class="dialog-header">\n    <img src="../img/icons/company-logo.png" alt="logo" class="logo">\n  </div>\n  <div class="dialog-content question-solution-dialog-content">\n\n    <div class="columns small-12">\n      <div class="portlet ques-port-desc">\n        <div class="portlet-title">\n          <div class="caption">\n            Question Description\n          </div>\n        </div>\n        <div class="portlet-body">\n          <mathjax-mcq-bind mcq="dialogViewQuestion"></mathjax-mcq-bind>\n        </div>\n      </div>\n    </div>\n\n    <div class="columns large-4 small-12">\n      <div class="portlet ques-port-desc">\n        <div class="portlet-title">\n          <div class="caption">\n            Question Info\n          </div>\n        </div>\n        <div class="portlet-body">\n          <div class="text-left">\n            <label class="inline-elem">Chapter: </label>\n            {{chapterName}}<br>\n            <label class="inline-elem">Topic: </label>\n            <span>{{topicName}}</span><br>\n            <label class="inline-elem">Concept: </label>{{dialogViewQuestion.concept?\'\':\'N/A\'}}\n            <span class="inline-block-elem" mathjax-bind="dialogViewQuestion.concept"></span><br>\n            <label class="inline-elem">Difficulty: </label>{{(dialogViewQuestion.difficultyLevel|capitalizeConstant)||\'N/A\'}}<br>\n            <label class="inline-elem">Skill Type: </label>{{(dialogViewQuestion.skillType|capitalizeConstant)||\'N/A\'}}<br>\n            <label class="inline-elem">Question Type: </label>{{(dialogViewQuestion.questionType|capitalizeConstant)||\'N/A\'}}\n          </div>\n        </div>\n      </div>\n    </div>\n\n    <div class="columns large-8 small-12">\n      <div class="portlet">\n        <div class="portlet-title">\n          <div class="caption">\n            Solution\n          </div>\n        </div>\n        <div class="portlet-body">\n          <div class="ques-pop-sol" mathjax-bind="dialogViewQuestion.solution"></div>\n        </div>\n      </div>\n    </div>\n  </div>\n\n  <div class="form-horizontal" role="form" id="panActions">\n    <div class="form-group">\n      <div class="row">\n        <div class="columns medium-12 small-12 mid-bt">\n          <a class="e-button radius" ng-click="closeThisDialog()">Close</a>\n        </div>\n      </div>\n    </div>\n  </div>\n</div>\n');
$templateCache.put('../teacher/dialog/select-coursework.html','<div class="erudex-dialog">\n  <div class="dialog-header">\n    <img src="../img/icons/company-logo.png" alt="logo" class="logo">\n  </div>\n  <div class="dialog-content">\n\n    <div class="row">\n      <div class="columns small-5 text-center">\n\n        <div class="select-resource-list-title">Available {{plan.name}}</div>\n        <div class="select-resource-list ng-hide" ng-hide="isLoading" ui-sortable="resourceSortableOptions" ng-model="availableCoursework">\n          <div ng-repeat="aRes in availableCoursework track by $index" class="select-resource-list-item noselect">\n            <img ng-src="{{iconSrc}}" class="resource-icon">\n            <span class="resource-name" ng-click="onClickCoursework(\'available\',$index)" ng-bind-html="aRes.name"></span>\n            <i class="fa fa-eye resource-preview-icon" ng-click="previewCoursework(aRes)"> </i>\n          </div>\n        </div>\n        <div class="text-center ng-hide" ng-show="isLoading">\n          Loading...<i class="fa fa-spinner fa-pulse"></i>\n        </div>\n\n      </div>\n      <div class="columns small-2 text-center" style="height:11rem">\n\n        <img src="../img/icons/switch.png" alt="switch" class="center">\n\n      </div>\n      <div class="columns small-5 text-center">\n\n        <div class="select-resource-list-title">Selected {{plan.name}}</div>\n        <div class="select-resource-list" ui-sortable="resourceSortableOptions" ng-model="selectedCoursework">\n          <div ng-repeat="sRes in selectedCoursework track by $index" class="select-resource-list-item noselect">\n            <img ng-src="{{iconSrc}}" class="resource-icon">\n            <span class="resource-name" ng-click="onClickCoursework(\'selected\',$index)">{{sRes.name}}</span>\n            <i class="fa fa-eye resource-preview-icon" ng-click="previewCoursework(sRes)"> </i>\n          </div>\n        </div>\n\n      </div>\n    </div>\n\n    <div class="row text-center" style="margin-top: 1.25rem">\n      <div class="e-button radius" ng-click="closeThisDialog()">Cancel</div>\n      <div class="e-button radius" ng-click="finishSelection()">Ok</div>\n    </div>\n\n  </div>\n</div>\n');
$templateCache.put('../teacher/dialog/select-resource.html','<div class="erudex-dialog">\n  <div class="dialog-header">\n    <img src="../img/icons/company-logo.png" alt="logo" class="logo">\n  </div>\n  <div class="dialog-content">\n    <ul class="breadcrumbs" style="margin: -1rem -1rem 0.5rem">\n      <li ng-class="{\'current\': viewLevel === \'subject\'}">\n        <a ng-click="viewChapters()">{{languageId === languageConstants.ENGLISH ? subject.name : subject.altName}}</a>\n      </li>\n      <li class="current" ng-hide="!chapter || viewLevel === \'subject\'">{{languageId === languageConstants.ENGLISH ? chapter.name : chapter.altName}}</li>\n    </ul>\n\n    <div class="row select-resource-row">\n\n      <div class="columns small-6 text-center ng-hide" ng-show="viewLevel === \'subject\'">\n        <div class="select-resource-list-title" style="padding-top: 0.575rem">Chapters</div>\n        <div class="select-resource-list full-height">\n          <div ng-repeat="ch in subject.chapters track by $index" class="select-resource-list-item clickable noselect">\n            <img ng-src="{{\'../img/icons/\' + subject.iconType + \'/chapter.png\'|trustResUrl}}" class="resource-icon">\n            <span class="resource-name" ng-click="selectChapter(ch)">{{languageId === languageConstants.ENGLISH ? ch.name : ch.altName}}</span>\n          </div>\n        </div>\n      </div>\n\n      <div class="columns small-6 text-center ng-hide" ng-show="viewLevel === \'chapter\'">\n\n        <div class="select-resource-list-title" style="text-decoration: none;padding-top: 0.575rem">\n          Chapter Resources\n        </div>\n        <div class="select-resource-list">\n\n          <div class="ng-hide" ng-hide="(chapter.filteredResources && chapter.filteredResources.length) || (chapter.filteredPracticeAssessments && chapter.filteredPracticeAssessments.length)">\n            None available\n          </div>\n          <div ng-repeat="aRes in chapter.filteredResources track by $index" class="select-resource-list-item clickable noselect">\n            <img ng-src="{{aRes.iconUri||getAttachmentResourceIconUri(aRes, subject)}}" class="resource-icon">\n            <span class="resource-name" ng-click="addResource(aRes)">\n              {{languageId === languageConstants.ENGLISH ? aRes.name : (aRes.altName || aRes.name)}}\n            </span>\n            <i class="fa fa-eye resource-preview-icon" ng-click="previewResource(aRes)"> </i>\n          </div>\n          <div ng-repeat="pAssess in chapter.filteredPracticeAssessments track by $index" class="select-resource-list-item clickable noselect">\n            <img ng-src="{{\'../img/icons/generic/assessment.png\'|trustResUrl}}" class="resource-icon">\n            <span class="resource-name" ng-click="addResource(pAssess)">{{pAssess.name}}</span>\n          </div>\n        </div>\n        <div class="select-resource-list-title" style="text-decoration: none;padding-top: 1rem">\n          Topic Resources\n        </div>\n        <div class="select-resource-list">\n          <div class="ng-hide" ng-hide="chapter.filteredTopicResources && chapter.filteredTopicResources.length">None\n            available\n          </div>\n          <div ng-repeat="aRes in chapter.filteredTopicResources track by $index" class="select-resource-list-item clickable noselect">\n            <img ng-src="{{aRes.iconUri||getAttachmentResourceIconUri(aRes, subject)}}" class="resource-icon">\n            <span class="resource-name" ng-click="addResource(aRes)">\n              {{languageId === languageConstants.ENGLISH ? aRes.name : (aRes.altName || aRes.name)}}\n            </span>\n            <i class="fa fa-eye resource-preview-icon" ng-click="previewResource(aRes)"> </i>\n          </div>\n        </div>\n\n      </div>\n      <div class="columns small-1 text-center select-resource-switch">\n\n        <img src="../img/icons/switch.png" alt="switch" class="center" ng-hide="viewLevel === \'subject\'">\n\n      </div>\n      <div class="columns small-5 text-center">\n\n        <div class="select-resource-list-title" style="padding-top: 0.575rem;text-decoration: none">Selected Resources\n        </div>\n        <div class="select-resource-list full-height selected-resources" ui-sortable="selectedResourceOptions" ng-model="selectedResources">\n          <div ng-repeat="sRes in selectedResources track by $index" class="select-resource-list-item clickable noselect">\n            <img ng-src="{{sRes.iconUri||getAttachmentResourceIconUri(sRes, subject)}}" class="resource-icon">\n            <span class="resource-name" ng-click="removeResource($index)">\n              {{languageId === languageConstants.ENGLISH ? sRes.name : (sRes.altName || sRes.name)}}\n            </span>\n            <i class="fa fa-eye resource-preview-icon ng-hide" ng-show="sRes.type === \'resource\'" ng-click="previewResource(sRes)"> </i>\n          </div>\n        </div>\n\n      </div>\n\n    </div>\n\n    <div class="row text-center" style="margin-top: 1.25rem">\n      <div class="e-button radius" ng-click="closeThisDialog()">Cancel</div>\n      <div class="e-button radius" ng-click="finishSelection()">Ok</div>\n    </div>\n  </div>\n</div>\n');
$templateCache.put('../teacher/dialog/show-print-options.html','<div class="erudex-dialog">\n  <div class="dialog-header">\n    <img src="../img/icons/company-logo.png" alt="logo" class="logo">\n  </div>\n  <div class="dialog-content">\n    <div class="options_select">\n      <input type="radio" name="options_group" id="option_ws" ng-checked="true" ng-click="selectPrintOption(false, false, false, false)">\n      <label for="option_ws"><span class="">Worksheet Format</span></label>\n    </div>\n    <div class="options_select">\n      <input type="radio" name="options_group" id="option_qz" ng-click="selectPrintOption(true, false, false, false)">\n      <label for="option_qz"><span class="">Exam Format</span></label>\n    </div>\n    <div class="options_select">\n      <input type="radio" name="options_group" id="option_key" ng-click="selectPrintOption(false, true, false, true)">\n      <label for="option_key"><span class="">Key</span></label>\n    </div>\n    <div class="options_select">\n      <input type="radio" name="options_group" id="option_sol" ng-click="selectPrintOption(true, false, true, false)">\n      <label for="option_sol"><span class="">Key & Solutions</span></label>\n    </div>\n\n    <div class="row text-center pb-1r">\n      <div class="button primary" ng-click="positiveResponse()" style="width:6rem">Print</div>\n      <div class="button primary" ng-click="negativeResponse()" style="width:6rem">Cancel</div>\n    </div>\n\n  </div>\n</div>\n');
$templateCache.put('../teacher/dialog/mauritius/assessment-add-questions.html','<div class="erudex-dialog fixed-dialog-buttons">\n    <div class="dialog-header">\n      <img src="../img/icons/company-logo.png" alt="logo" class="logo">\n    </div>\n    <div class="dialog-content">\n  \n      <div class="row">\n        <div class="columns small-1">\n          <label class="inline-label text-center">Grade</label>\n  \n          <label ng-hide="(assessmentType === ASSESSMENT_TYPE.COMPETITIVE_MOCK_TEST) || (assessmentType === ASSESSMENT_TYPE.COMPETITIVE_PRACTICE)" class="inline-label text-center">\n            {{ grade.number || grade.description }}\n          </label>\n  \n          <select ng-model="grade" ng-change="onChangeGrade(grade)" ng-options="opt.value as opt.name for opt in gradeOptions" ng-show="(assessmentType === ASSESSMENT_TYPE.COMPETITIVE_MOCK_TEST) || (assessmentType === ASSESSMENT_TYPE.COMPETITIVE_PRACTICE)">\n          </select>\n  \n        </div>\n  \n        <div class="columns small-2">\n          <label class="inline-label text-center">Subject</label>\n  \n          <label ng-hide="(assessmentType === ASSESSMENT_TYPE.COMPETITIVE_MOCK_TEST) || (assessmentType === ASSESSMENT_TYPE.COMPETITIVE_PRACTICE)" class="inline-label text-center">\n            {{language.id === languageConstants.ENGLISH ? subject.name : (subject.altName || subject.name)}}\n          </label>\n  \n          <select ng-model="subject" ng-change="onChangeSubject(subject)" ng-options="opt.value as opt.name for opt in subjectOptions" ng-show="(assessmentType === ASSESSMENT_TYPE.COMPETITIVE_MOCK_TEST) || (assessmentType === ASSESSMENT_TYPE.COMPETITIVE_PRACTICE)">\n            <option selected="selected" value="">All Subjects</option>\n          </select>\n        </div>\n  \n        <div class="columns small-2">\n          <label class="inline-label text-center">Question Type</label>\n          <select ng-model="filter.questionType" ng-change="onChangeQuestionType(filter.questionType)" ng-options="obj.value as obj.name for obj in questionTypeOptions">\n            <option selected="selected" value="">All Question Types</option>\n          </select>\n        </div>\n        \n        <div class="columns small-2">\n          <label class="inline-label text-center">Created By</label>\n          <select ng-model="filter.createdUserId" ng-change="applyFilter(filter)">\n            <option selected="filter.createdUserId == null || filter.createdUserId == \'\' " value="">All</option>\n            <option type="number" selected="filter.createdUserId == user.id" value="{{user.id}}">Me</option>\n          </select>\n        </div>\n\n        <div class="columns small-2 end" ng-hide="features.questionAdd.offlineSearch">\n          <label class="inline-label text-center">Description</label>\n          <input type="text" maxlength="100" ng-model="filter.description">\n        </div>\n      </div>\n  \n  \n      <div class="row text-center no-select">\n        <div class="e-button radius" ng-click="clearFilter()">Clear Filter</div>\n        <div class="e-button radius" ng-click="applyFilter()">Apply Filter</div>\n      </div>\n  \n      <table class="f-table striped">\n        <thead>\n        <tr ng-show="selectedSubjects.length > 0">\n          <th class="text-right">\n            &nbsp;\n          </th>\n          <th>\n            <div class="row text-right">\n              <div ng-repeat="subject in selectedSubjects" class="columns small-3 end">\n                {{subject.name}} - {{subject.count}}\n              </div>\n            </div>\n          </th>\n          <th colspan="3" class="text-right">\n            &nbsp;\n          </th>\n        </tr>\n        <tr>\n          <th width="6%"> No.</th>\n          <th width="62%"> Question</th>\n          <th width="13%"> Question Type</th>\n          <th width="13%"> Created By</th>\n          <th width="6%"> Action</th>\n        </tr>\n        </thead>\n        <tbody>\n        <tr ng-if="!loadedQuestions || loadedQuestions.length === 0">\n          <td colspan="5"><em>No Questions Available</em></td>\n        </tr>\n        <tr ng-repeat="rec in loadedQuestions track by $index">\n          <td ng-click="viewQuestion(rec)">{{(search.pagination.pageIndex*search.pagination.pageSize)+$index+1}}</td>\n          <td class="ques-text" ng-click="viewQuestion(rec)">\n            <mathjax-mcq-bind mcq="rec"></mathjax-mcq-bind>\n          </td>\n          <td class="text-left">\n            <label class="inline-elem">{{(rec.questionType|capitalizeConstant)||\'N/A\'}}</label><br>\n          </td>\n          <td class="text-left">\n            <label class="inline-elem">{{(rec.createdUsername)||\'N/A\'}}</label><br>\n            <label class="inline-elem">{{rec.createdDateTime | date:\'dd-MM-yyyy hh:mm a\'}}</label>\n          </td>\n          <td class="no-select">\n            <div class="e-button radius" ng-click="selectQuestion(rec)" ng-show="rec.isActive">\n              {{isSelectedQuestion(rec.id)?\'Deselect\':\'Add\'}}\n            </div>\n            <div ng-hide="rec.isActive"><em>Disabled</em></div>\n            <div class="e-button radius" ng-click="viewQuestionHistory(rec.id)">Info</div>\n          </td>\n        </tr>\n        </tbody>\n      </table>\n  \n    </div>\n    <div class="dialog-buttons">\n      <div class="pagination-footer row">\n        <div class="columns small-5">\n          <div class="row">\n            <div class="columns small-6 text-left">\n              Search Results: {{(search.pagination.pageIndex*search.pagination.pageSize)+1}}\n              - {{(search.pagination.pageIndex*search.pagination.pageSize)+loadedQuestions.length}}/{{totalQuestions}}\n            </div>\n            <div class="columns small-6">\n              Page: {{search.pagination.pageIndex+1}}/{{totalPages}}\n            </div>\n          </div>\n        </div>\n        <div class="columns small-2">\n          <div class="e-button radius" ng-click="cancel()">Cancel</div>\n          <div class="e-button radius" ng-click="okay()">Ok</div>\n        </div>\n        <div class="columns small-5">\n          <div class="row">\n            <div class="columns small-8 text-right">\n              <pagination boundary-links="true" total-items="totalQuestions" page="search.pagination.pageIndex+1" on-select-page="goToPage(page)" max-size="5" rotate="true" class="pagination-fixed" previous-text="&lt;" next-text="&gt;" first-text="&lt;&lt;" last-text="&gt;&gt;"></pagination>\n            </div>\n            <div class="columns small-2 text-right">\n              <div class="go-to-label">Go To:</div>\n            </div>\n            <div class="columns small-2">\n              <span class="go-to-select">\n              <input type="number" class="text-center" ng-model="search.pagination.jumpToPageNum" ng-keydown="$event.keyCode===13 ? goToPage(search.pagination.jumpToPageNum) || $event.preventDefault():\'\'">\n              </span>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n');
$templateCache.put('../teacher/dialog/mauritius/question-view-history.html','<div class="erudex-dialog">\n    <div class="dialog-header">\n      <img src="../img/icons/company-logo.png" alt="logo" class="logo-left">\n      Question History\n    </div>\n    <div class="dialog-content">\n      <div class="ques-history-modal">\n        <table class="f-table striped">\n          <thead>\n          <tr>\n            <th> Assessment Name</th>\n            <th> Assessment Type</th>\n            <th> Created By</th>\n            <th> Created Date</th>\n          </tr>\n          </thead>\n          <tbody>\n          <tr ng-repeat="rec in mcqHistory">\n            <td>{{rec[1]}}</td>\n            <td>{{getAssessmentType(rec[3]||rec[3])}}</td>\n            <td>{{rec[0]}}</td>\n            <td>{{rec[4] | date:\'dd-MM-yyyy\'}}</td>\n          </tr>\n          <tr ng-show="isHistoryLoaded && (mcqHistory.length === 0)">\n            <td colspan="5">This question not used in any assessment yet.</td>\n          </tr>\n          </tbody>\n        </table>\n      </div>\n    </div>\n    <div class="form-horizontal" role="form" id="panActions">\n      <div class="form-group">\n        <div class="row">\n          <div class="columns medium-12 small-12 mid-bt">\n            <a class="e-button radius" ng-click="closeThisDialog()">Close</a>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n  ');}]);